local t = Def.ActorFrame{
	Name="WheelItemSectionOpened";

	LoadActor( THEME:GetPathB("","_frame 3x3"), "_rounded blackinset transparent header", 256, 24)..{
		Name="SectionBG";
		SetMessageCommand=function(self,params)
			if params.Text ~= "" or GAMESTATE:GetSortOrder() == 'SortOrder_ModeMenu' then self:visible(true)
			else self:visible(false);
			end;

			-- color based on song group
			local group = params.Text;
			if group and GAMESTATE:GetSortOrder() == 'SortOrder_Group' then
				if group ~= "" and group ~= "N/A" then
					local color = SONGMAN:GetSongGroupColor(group);
					local hsvTable = ColorToHSV(color);
					hsvTable.Sat = 0.45;
					self:diffuse( HSVToColor(hsvTable) );
				else
					self:diffuse( color("1,1,1,1") );
				end;
			else
				self:diffuse( color("1,1,1,1") );
			end;

			-- xxx: color for other sorts?
		end;
	};
	Def.ActorFrame{
		Name="RouletteItem";
		SetMessageCommand=function(self,params)
			if params.Text == "" and GAMESTATE:GetSortOrder() ~= 'SortOrder_ModeMenu' then
				self:visible(true)
			else
				self:visible(false);
			end;

			self:GetParent():GetChild("SectionLabel"):settext("");
		end;

		LoadActor( THEME:GetPathB("","_frame 3x3"), "_rounded blackinset transparent normal", 256, 24)..{
			Name="RouletteBG";
		};
	};
	AutoText("frutiger",true)..{
		Name="SectionLabel";
		InitCommand=cmd(x,-132;y,-18;horizalign,left;zoom,0.45;shadowlength,0;diffuse,color("#000000");strokecolor,color("0,0,0,0"));
		OnCommand=cmd(playcommand,"Set");
		SortOrderChangedMessageCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			local sortOrder = GAMESTATE:GetSortOrder();
			local text = THEME:GetString("MusicWheelItem", ToEnumShortString(sortOrder));
			self:settext( text );
		end;

		SetMessageCommand=function(self,params)
			-- roulette hack!
			local sortOrder = GAMESTATE:GetSortOrder();
			local text;

			if not params then
				return;
			end;
			if params.Text == "" and sortOrder ~= 'SortOrder_ModeMenu' then
				text = "";
			else
				text = THEME:GetString("MusicWheelItem", ToEnumShortString(sortOrder));
			end;
			self:settext( text );
		end;
	};
};

return t;